package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBelarus: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇾",
        description = "flag: Belarus",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-belarus", "belarus-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Belarus.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBelarus: Emoji get() = _FlagBelarus

/**
 * Alias to emoji [FlagBelarus] (Flags: country-flag: flag: Belarus).
*/
public val Emoji.Companion.BelarusFlag: Emoji get() = _FlagBelarus
