package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagClippertonIsland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇵",
        description = "flag: Clipperton Island",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-clipperton-island", "clipperton-island-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Clipperton Island.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagClippertonIsland: Emoji get() = _FlagClippertonIsland

/**
 * Alias to emoji [FlagClippertonIsland] (Flags: country-flag: flag: Clipperton Island).
*/
public val Emoji.Companion.ClippertonIslandFlag: Emoji get() = _FlagClippertonIsland
