package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCocosKeelingIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇨",
        description = "flag: Cocos (Keeling) Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-cocos-keeling-islands", "cocos-islands-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Cocos (Keeling) Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCocosKeelingIslands: Emoji get() = _FlagCocosKeelingIslands

/**
 * Alias to emoji [FlagCocosKeelingIslands] (Flags: country-flag: flag: Cocos (Keeling) Islands).
*/
public val Emoji.Companion.CocosIslandsFlag: Emoji get() = _FlagCocosKeelingIslands
