package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCookIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇰",
        description = "flag: Cook Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-cook-islands", "cook-islands-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Cook Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCookIslands: Emoji get() = _FlagCookIslands

/**
 * Alias to emoji [FlagCookIslands] (Flags: country-flag: flag: Cook Islands).
*/
public val Emoji.Companion.CookIslandsFlag: Emoji get() = _FlagCookIslands
