package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagEcuador: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇪🇨",
        description = "flag: Ecuador",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-ecuador", "ecuador-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Ecuador.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagEcuador: Emoji get() = _FlagEcuador

/**
 * Alias to emoji [FlagEcuador] (Flags: country-flag: flag: Ecuador).
*/
public val Emoji.Companion.EcuadorFlag: Emoji get() = _FlagEcuador
