package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagFalklandIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇫🇰",
        description = "flag: Falkland Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-falkland-islands", "falkland-islands-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Falkland Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagFalklandIslands: Emoji get() = _FlagFalklandIslands

/**
 * Alias to emoji [FlagFalklandIslands] (Flags: country-flag: flag: Falkland Islands).
*/
public val Emoji.Companion.FalklandIslandsFlag: Emoji get() = _FlagFalklandIslands
