package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagFrenchGuiana: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇫",
        description = "flag: French Guiana",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-french-guiana", "french-guiana-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: French Guiana.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagFrenchGuiana: Emoji get() = _FlagFrenchGuiana

/**
 * Alias to emoji [FlagFrenchGuiana] (Flags: country-flag: flag: French Guiana).
*/
public val Emoji.Companion.FrenchGuianaFlag: Emoji get() = _FlagFrenchGuiana
