package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagFrenchPolynesia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇫",
        description = "flag: French Polynesia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-french-polynesia", "french-polynesia-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: French Polynesia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagFrenchPolynesia: Emoji get() = _FlagFrenchPolynesia

/**
 * Alias to emoji [FlagFrenchPolynesia] (Flags: country-flag: flag: French Polynesia).
*/
public val Emoji.Companion.FrenchPolynesiaFlag: Emoji get() = _FlagFrenchPolynesia
