package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGreenland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇱",
        description = "flag: Greenland",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-greenland", "greenland-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Greenland.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGreenland: Emoji get() = _FlagGreenland

/**
 * Alias to emoji [FlagGreenland] (Flags: country-flag: flag: Greenland).
*/
public val Emoji.Companion.GreenlandFlag: Emoji get() = _FlagGreenland
