package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagIceland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇮🇸",
        description = "flag: Iceland",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-iceland", "iceland-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.3888888f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Iceland.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagIceland: Emoji get() = _FlagIceland

/**
 * Alias to emoji [FlagIceland] (Flags: country-flag: flag: Iceland).
*/
public val Emoji.Companion.IcelandFlag: Emoji get() = _FlagIceland
