package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagItaly: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇮🇹",
        description = "flag: Italy",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flag-italy", "italy-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Italy.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagItaly: Emoji get() = _FlagItaly

/**
 * Alias to emoji [FlagItaly] (Flags: country-flag: flag: Italy).
*/
public val Emoji.Companion.ItalyFlag: Emoji get() = _FlagItaly
