package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagJamaica: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇯🇲",
        description = "flag: Jamaica",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-jamaica", "jamaica-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Jamaica.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagJamaica: Emoji get() = _FlagJamaica

/**
 * Alias to emoji [FlagJamaica] (Flags: country-flag: flag: Jamaica).
*/
public val Emoji.Companion.JamaicaFlag: Emoji get() = _FlagJamaica
