package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagJersey: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇯🇪",
        description = "flag: Jersey",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-jersey", "jersey-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.6666666f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Jersey.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagJersey: Emoji get() = _FlagJersey

/**
 * Alias to emoji [FlagJersey] (Flags: country-flag: flag: Jersey).
*/
public val Emoji.Companion.JerseyFlag: Emoji get() = _FlagJersey
