package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagLatvia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇱🇻",
        description = "flag: Latvia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-latvia", "latvia-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Latvia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagLatvia: Emoji get() = _FlagLatvia

/**
 * Alias to emoji [FlagLatvia] (Flags: country-flag: flag: Latvia).
*/
public val Emoji.Companion.LatviaFlag: Emoji get() = _FlagLatvia
