package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMauritania: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇷",
        description = "flag: Mauritania",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-mauritania", "mauritania-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Mauritania.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMauritania: Emoji get() = _FlagMauritania

/**
 * Alias to emoji [FlagMauritania] (Flags: country-flag: flag: Mauritania).
*/
public val Emoji.Companion.MauritaniaFlag: Emoji get() = _FlagMauritania
