package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSerbia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇷🇸",
        description = "flag: Serbia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-serbia", "serbia-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Serbia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSerbia: Emoji get() = _FlagSerbia

/**
 * Alias to emoji [FlagSerbia] (Flags: country-flag: flag: Serbia).
*/
public val Emoji.Companion.SerbiaFlag: Emoji get() = _FlagSerbia
