package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTajikistan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇯",
        description = "flag: Tajikistan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-tajikistan", "tajikistan-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Tajikistan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTajikistan: Emoji get() = _FlagTajikistan

/**
 * Alias to emoji [FlagTajikistan] (Flags: country-flag: flag: Tajikistan).
*/
public val Emoji.Companion.TajikistanFlag: Emoji get() = _FlagTajikistan
