package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagUnitedArabEmirates: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇪",
        description = "flag: United Arab Emirates",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-united-arab-emirates", "united-arab-emirates-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: United Arab Emirates.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagUnitedArabEmirates: Emoji get() = _FlagUnitedArabEmirates

/**
 * Alias to emoji [FlagUnitedArabEmirates] (Flags: country-flag: flag: United Arab Emirates).
*/
public val Emoji.Companion.UnitedArabEmiratesFlag: Emoji get() = _FlagUnitedArabEmirates
