package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BottleWithPoppingCork: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍾",
        description = "bottle with popping cork",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("bottle-with-popping-cork", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: bottle with popping cork.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BottleWithPoppingCork: Emoji get() = _BottleWithPoppingCork
