package org.kodein.emoji.objects.book_paper

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllBookPaper() {
    add(intArrayOf(0x1f4d4), _NotebookWithDecorativeCover)
    add(intArrayOf(0x1f4d5), _ClosedBook)
    add(intArrayOf(0x1f4d6), _OpenBook)
    add(intArrayOf(0x1f4d7), _GreenBook)
    add(intArrayOf(0x1f4d8), _BlueBook)
    add(intArrayOf(0x1f4d9), _OrangeBook)
    add(intArrayOf(0x1f4da), _Books)
    add(intArrayOf(0x1f4d3), _Notebook)
    add(intArrayOf(0x1f4d2), _Ledger)
    add(intArrayOf(0x1f4c3), _PageWithCurl)
    add(intArrayOf(0x1f4dc), _Scroll)
    add(intArrayOf(0x1f4c4), _PageFacingUp)
    add(intArrayOf(0x1f4f0), _Newspaper)
    add(intArrayOf(0x1f5de, 0xfe0f), _RolledUpNewspaper)
    add(intArrayOf(0x1f5de), _RolledUpNewspaper)
    add(intArrayOf(0x1f4d1), _BookmarkTabs)
    add(intArrayOf(0x1f516), _Bookmark)
    add(intArrayOf(0x1f3f7, 0xfe0f), _Label)
    add(intArrayOf(0x1f3f7), _Label)
}

internal suspend fun SequenceScope<Emoji>.yieldAllBookPaper() {
    yield(_NotebookWithDecorativeCover)
    yield(_ClosedBook)
    yield(_OpenBook)
    yield(_GreenBook)
    yield(_BlueBook)
    yield(_OrangeBook)
    yield(_Books)
    yield(_Notebook)
    yield(_Ledger)
    yield(_PageWithCurl)
    yield(_Scroll)
    yield(_PageFacingUp)
    yield(_Newspaper)
    yield(_RolledUpNewspaper)
    yield(_BookmarkTabs)
    yield(_Bookmark)
    yield(_Label)
}

internal val countBookPaper = 17

/**
 * All Emoji of the Objects: book-paper subgroup.
*/
public fun Emoji.Companion.sequenceBookPaper(): Sequence<Emoji> =
    sequence { yieldAllBookPaper() }

/**
 * All Emoji of the Objects: book-paper subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listBookPaper(): List<Emoji> =
    ArrayList<Emoji>(countBookPaper).also { list -> sequenceBookPaper().forEach { list.add(it) } }

@Deprecated("Renamed listBookPaper.", replaceWith = ReplaceWith("listBookPaper()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allBookPaper(): List<Emoji> =
    listBookPaper()
