package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BilledCap: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧢",
        description = "billed cap",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("billed-cap", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: billed cap.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BilledCap: Emoji get() = _BilledCap
