package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GraduationCap: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎓",
        description = "graduation cap",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("graduation-cap", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Objects: clothing: graduation cap.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GraduationCap: Emoji get() = _GraduationCap
