package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LabCoat: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥼",
        description = "lab coat",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("lab-coat", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: lab coat.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LabCoat: Emoji get() = _LabCoat
