package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Sunglasses: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕶️",
        description = "sunglasses",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("sunglasses", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: sunglasses.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Sunglasses: Emoji get() = _Sunglasses
