package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WomansClothes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👚",
        description = "woman’s clothes",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("womans-clothes", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: woman’s clothes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WomansClothes: Emoji get() = _WomansClothes
