package org.kodein.emoji.objects.computer

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ElectricPlug: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔌",
        description = "electric plug",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("electric-plug", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: computer: electric plug.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ElectricPlug: Emoji get() = _ElectricPlug
