package org.kodein.emoji.objects.light_video

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _VideoCamera: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📹",
        description = "video camera",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("video-camera", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: light & video: video camera.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.VideoCamera: Emoji get() = _VideoCamera
