package org.kodein.emoji.objects.light_video

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllLightVideo() {
    add(intArrayOf(0x1f3a5), _MovieCamera)
    add(intArrayOf(0x1f39e, 0xfe0f), _FilmFrames)
    add(intArrayOf(0x1f39e), _FilmFrames)
    add(intArrayOf(0x1f4fd, 0xfe0f), _FilmProjector)
    add(intArrayOf(0x1f4fd), _FilmProjector)
    add(intArrayOf(0x1f3ac), _ClapperBoard)
    add(intArrayOf(0x1f4fa), _Television)
    add(intArrayOf(0x1f4f7), _Camera)
    add(intArrayOf(0x1f4f8), _CameraWithFlash)
    add(intArrayOf(0x1f4f9), _VideoCamera)
    add(intArrayOf(0x1f4fc), _Videocassette)
    add(intArrayOf(0x1f50d), _MagnifyingGlassTiltedLeft)
    add(intArrayOf(0x1f50e), _MagnifyingGlassTiltedRight)
    add(intArrayOf(0x1f56f, 0xfe0f), _Candle)
    add(intArrayOf(0x1f56f), _Candle)
    add(intArrayOf(0x1f4a1), _LightBulb)
    add(intArrayOf(0x1f526), _Flashlight)
    add(intArrayOf(0x1f3ee), _RedPaperLantern)
    add(intArrayOf(0x1fa94), _DiyaLamp)
}

internal suspend fun SequenceScope<Emoji>.yieldAllLightVideo() {
    yield(_MovieCamera)
    yield(_FilmFrames)
    yield(_FilmProjector)
    yield(_ClapperBoard)
    yield(_Television)
    yield(_Camera)
    yield(_CameraWithFlash)
    yield(_VideoCamera)
    yield(_Videocassette)
    yield(_MagnifyingGlassTiltedLeft)
    yield(_MagnifyingGlassTiltedRight)
    yield(_Candle)
    yield(_LightBulb)
    yield(_Flashlight)
    yield(_RedPaperLantern)
    yield(_DiyaLamp)
}

internal val countLightVideo = 16

/**
 * All Emoji of the Objects: light & video subgroup.
*/
public fun Emoji.Companion.sequenceLightVideo(): Sequence<Emoji> =
    sequence { yieldAllLightVideo() }

/**
 * All Emoji of the Objects: light & video subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listLightVideo(): List<Emoji> =
    ArrayList<Emoji>(countLightVideo).also { list -> sequenceLightVideo().forEach { list.add(it) } }

@Deprecated("Renamed listLightVideo.", replaceWith = ReplaceWith("listLightVideo()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allLightVideo(): List<Emoji> =
    listLightVideo()
