package org.kodein.emoji.objects.mail

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _IncomingEnvelope: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📨",
        description = "incoming envelope",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("incoming-envelope", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: mail: incoming envelope.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.IncomingEnvelope: Emoji get() = _IncomingEnvelope
