package org.kodein.emoji.objects.money

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _EuroBanknote: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💶",
        description = "euro banknote",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("euro-banknote", "euro"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: money: euro banknote.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.EuroBanknote: Emoji get() = _EuroBanknote

/**
 * Alias to emoji [EuroBanknote] (Objects: money: euro banknote).
*/
public val Emoji.Companion.Euro: Emoji get() = _EuroBanknote
