package org.kodein.emoji.objects.music

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Headphone: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎧",
        description = "headphone",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("headphone", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: music: headphone.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Headphone: Emoji get() = _Headphone
