package org.kodein.emoji.objects.musical_instrument

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MusicalKeyboard: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎹",
        description = "musical keyboard",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("musical-keyboard", "piano"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: musical-instrument: musical keyboard.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MusicalKeyboard: Emoji get() = _MusicalKeyboard

/**
 * Alias to emoji [MusicalKeyboard] (Objects: musical-instrument: musical keyboard).
*/
public val Emoji.Companion.Piano: Emoji get() = _MusicalKeyboard
