package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CardIndexDividers: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗂️",
        description = "card index dividers",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("card-index-dividers", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: office: card index dividers.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CardIndexDividers: Emoji get() = _CardIndexDividers
