package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Paperclip: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📎",
        description = "paperclip",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("paperclip", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: office: paperclip.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Paperclip: Emoji get() = _Paperclip
