package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RoundPushpin: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📍",
        description = "round pushpin",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("round-pushpin", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: office: round pushpin.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RoundPushpin: Emoji get() = _RoundPushpin
