package org.kodein.emoji.objects.phone

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaxMachine: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📠",
        description = "fax machine",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("fax-machine", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: phone: fax machine.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaxMachine: Emoji get() = _FaxMachine
