package org.kodein.emoji.objects.sound

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SpeakerLowVolume: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔈",
        description = "speaker low volume",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("speaker-low-volume", "low-volume"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: sound: speaker low volume.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SpeakerLowVolume: Emoji get() = _SpeakerLowVolume

/**
 * Alias to emoji [SpeakerLowVolume] (Objects: sound: speaker low volume).
*/
public val Emoji.Companion.LowVolume: Emoji get() = _SpeakerLowVolume
