package org.kodein.emoji.people_body

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.people_body.hand_fingers_open.*
import org.kodein.emoji.people_body.hand_fingers_partial.*
import org.kodein.emoji.people_body.hand_single_finger.*
import org.kodein.emoji.people_body.hand_fingers_closed.*
import org.kodein.emoji.people_body.hands.*
import org.kodein.emoji.people_body.hand_prop.*
import org.kodein.emoji.people_body.body_parts.*
import org.kodein.emoji.people_body.person.*
import org.kodein.emoji.people_body.person_gesture.*
import org.kodein.emoji.people_body.person_role.*
import org.kodein.emoji.people_body.person_fantasy.*
import org.kodein.emoji.people_body.person_activity.*
import org.kodein.emoji.people_body.person_sport.*
import org.kodein.emoji.people_body.person_resting.*
import org.kodein.emoji.people_body.family.*
import org.kodein.emoji.people_body.person_symbol.*


internal fun EmojiFinder.addAllPeopleBody() {
    addAllHandFingersOpen()
    addAllHandFingersPartial()
    addAllHandSingleFinger()
    addAllHandFingersClosed()
    addAllHands()
    addAllHandProp()
    addAllBodyParts()
    addAllPerson()
    addAllPersonGesture()
    addAllPersonRole()
    addAllPersonFantasy()
    addAllPersonActivity()
    addAllPersonSport()
    addAllPersonResting()
    addAllFamily()
    addAllPersonSymbol()
}

internal suspend fun SequenceScope<Emoji>.yieldAllPeopleBody() {
    yieldAllHandFingersOpen()
    yieldAllHandFingersPartial()
    yieldAllHandSingleFinger()
    yieldAllHandFingersClosed()
    yieldAllHands()
    yieldAllHandProp()
    yieldAllBodyParts()
    yieldAllPerson()
    yieldAllPersonGesture()
    yieldAllPersonRole()
    yieldAllPersonFantasy()
    yieldAllPersonActivity()
    yieldAllPersonSport()
    yieldAllPersonResting()
    yieldAllFamily()
    yieldAllPersonSymbol()
}

internal val countPeopleBody = 385

/**
 * All Emoji of the People & Body group.
*/
public fun Emoji.Companion.sequencePeopleBody(): Sequence<Emoji> =
    sequence { yieldAllPeopleBody() }

/**
 * All Emoji of the People & Body group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allPeopleBody(): List<Emoji> =
    ArrayList<Emoji>(countPeopleBody).also { list -> sequencePeopleBody().forEach { list.add(it) } }

internal fun allPeopleBodySubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "hand_fingers_open" to { Emoji.listHandFingersOpen() },
        "hand_fingers_partial" to { Emoji.listHandFingersPartial() },
        "hand_single_finger" to { Emoji.listHandSingleFinger() },
        "hand_fingers_closed" to { Emoji.listHandFingersClosed() },
        "hands" to { Emoji.listHands() },
        "hand_prop" to { Emoji.listHandProp() },
        "body_parts" to { Emoji.listBodyParts() },
        "person" to { Emoji.listPerson() },
        "person_gesture" to { Emoji.listPersonGesture() },
        "person_role" to { Emoji.listPersonRole() },
        "person_fantasy" to { Emoji.listPersonFantasy() },
        "person_activity" to { Emoji.listPersonActivity() },
        "person_sport" to { Emoji.listPersonSport() },
        "person_resting" to { Emoji.listPersonResting() },
        "family" to { Emoji.listFamily() },
        "person_symbol" to { Emoji.listPersonSymbol() },
    )
