package org.kodein.emoji.people_body.body_parts

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BitingLip: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫦",
        description = "biting lip",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("biting-lip", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji People & Body: body-parts: biting lip.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BitingLip: Emoji get() = _BitingLip
