package org.kodein.emoji.people_body.body_parts

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MechanicalLeg: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🦿",
        description = "mechanical leg",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("mechanical-leg", "leg-mechanical"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji People & Body: body-parts: mechanical leg.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MechanicalLeg: Emoji get() = _MechanicalLeg

/**
 * Alias to emoji [MechanicalLeg] (People & Body: body-parts: mechanical leg).
*/
public val Emoji.Companion.LegMechanical: Emoji get() = _MechanicalLeg
