package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _KissWomanMan: SkinTone2Emoji = SkinTone2EmojiImpl(
    details = Emoji.Details(
        string = "👩‍❤️‍💋‍👨",
        description = "kiss: woman, man",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("kiss-woman-man", "kiss-woman-and-man"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk21c = 2,
    sk22c = 11,
)

/**
 * Emoji People & Body: family: kiss: woman, man.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.KissWomanMan: SkinTone2Emoji get() = _KissWomanMan

/**
 * Alias to emoji [KissWomanMan] (People & Body: family: kiss: woman, man).
*/
public val Emoji.Companion.KissWomanAndMan: SkinTone2Emoji get() = _KissWomanMan
