package org.kodein.emoji.people_body.hand_fingers_closed

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _RightFacingFist: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🤜",
        description = "right-facing fist",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("right-facing-fist", "fist-rightwards"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-closed: right-facing fist.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RightFacingFist: SkinTone1Emoji get() = _RightFacingFist

/**
 * Alias to emoji [RightFacingFist] (People & Body: hand-fingers-closed: right-facing fist).
*/
public val Emoji.Companion.FistRightwards: SkinTone1Emoji get() = _RightFacingFist
