package org.kodein.emoji.people_body.hand_fingers_open

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHandFingersOpen() {
    add(intArrayOf(0x1f44b), _WavingHand)
    addVariations(intArrayOf(0x1f44b, 0x0), _WavingHand, 1)
    add(intArrayOf(0x1f91a), _RaisedBackOfHand)
    addVariations(intArrayOf(0x1f91a, 0x0), _RaisedBackOfHand, 1)
    add(intArrayOf(0x1f590, 0xfe0f), _HandWithFingersSplayed)
    add(intArrayOf(0x1f590), _HandWithFingersSplayed)
    addVariations(intArrayOf(0x1f590, 0x0), _HandWithFingersSplayed, 1)
    add(intArrayOf(0x270b), _RaisedHand)
    addVariations(intArrayOf(0x270b, 0x0), _RaisedHand, 1)
    add(intArrayOf(0x1f596), _VulcanSalute)
    addVariations(intArrayOf(0x1f596, 0x0), _VulcanSalute, 1)
    add(intArrayOf(0x1faf1), _RightwardsHand)
    addVariations(intArrayOf(0x1faf1, 0x0), _RightwardsHand, 1)
    add(intArrayOf(0x1faf2), _LeftwardsHand)
    addVariations(intArrayOf(0x1faf2, 0x0), _LeftwardsHand, 1)
    add(intArrayOf(0x1faf3), _PalmDownHand)
    addVariations(intArrayOf(0x1faf3, 0x0), _PalmDownHand, 1)
    add(intArrayOf(0x1faf4), _PalmUpHand)
    addVariations(intArrayOf(0x1faf4, 0x0), _PalmUpHand, 1)
    add(intArrayOf(0x1faf7), _LeftwardsPushingHand)
    addVariations(intArrayOf(0x1faf7, 0x0), _LeftwardsPushingHand, 1)
    add(intArrayOf(0x1faf8), _RightwardsPushingHand)
    addVariations(intArrayOf(0x1faf8, 0x0), _RightwardsPushingHand, 1)
}

internal suspend fun SequenceScope<Emoji>.yieldAllHandFingersOpen() {
    yield(_WavingHand)
    yield(_RaisedBackOfHand)
    yield(_HandWithFingersSplayed)
    yield(_RaisedHand)
    yield(_VulcanSalute)
    yield(_RightwardsHand)
    yield(_LeftwardsHand)
    yield(_PalmDownHand)
    yield(_PalmUpHand)
    yield(_LeftwardsPushingHand)
    yield(_RightwardsPushingHand)
}

internal val countHandFingersOpen = 11

/**
 * All Emoji of the People & Body: hand-fingers-open subgroup.
*/
public fun Emoji.Companion.sequenceHandFingersOpen(): Sequence<Emoji> =
    sequence { yieldAllHandFingersOpen() }

/**
 * All Emoji of the People & Body: hand-fingers-open subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listHandFingersOpen(): List<Emoji> =
    ArrayList<Emoji>(countHandFingersOpen).also { list -> sequenceHandFingersOpen().forEach { list.add(it) } }

@Deprecated("Renamed listHandFingersOpen.", replaceWith = ReplaceWith("listHandFingersOpen()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allHandFingersOpen(): List<Emoji> =
    listHandFingersOpen()
