package org.kodein.emoji.people_body.hand_single_finger

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHandSingleFinger() {
    add(intArrayOf(0x1f448), _BackhandIndexPointingLeft)
    addVariations(intArrayOf(0x1f448, 0x0), _BackhandIndexPointingLeft, 1)
    add(intArrayOf(0x1f449), _BackhandIndexPointingRight)
    addVariations(intArrayOf(0x1f449, 0x0), _BackhandIndexPointingRight, 1)
    add(intArrayOf(0x1f446), _BackhandIndexPointingUp)
    addVariations(intArrayOf(0x1f446, 0x0), _BackhandIndexPointingUp, 1)
    add(intArrayOf(0x1f595), _MiddleFinger)
    addVariations(intArrayOf(0x1f595, 0x0), _MiddleFinger, 1)
    add(intArrayOf(0x1f447), _BackhandIndexPointingDown)
    addVariations(intArrayOf(0x1f447, 0x0), _BackhandIndexPointingDown, 1)
    add(intArrayOf(0x261d, 0xfe0f), _IndexPointingUp)
    add(intArrayOf(0x261d), _IndexPointingUp)
    addVariations(intArrayOf(0x261d, 0x0), _IndexPointingUp, 1)
    add(intArrayOf(0x1faf5), _IndexPointingAtTheViewer)
    addVariations(intArrayOf(0x1faf5, 0x0), _IndexPointingAtTheViewer, 1)
}

internal suspend fun SequenceScope<Emoji>.yieldAllHandSingleFinger() {
    yield(_BackhandIndexPointingLeft)
    yield(_BackhandIndexPointingRight)
    yield(_BackhandIndexPointingUp)
    yield(_MiddleFinger)
    yield(_BackhandIndexPointingDown)
    yield(_IndexPointingUp)
    yield(_IndexPointingAtTheViewer)
}

internal val countHandSingleFinger = 7

/**
 * All Emoji of the People & Body: hand-single-finger subgroup.
*/
public fun Emoji.Companion.sequenceHandSingleFinger(): Sequence<Emoji> =
    sequence { yieldAllHandSingleFinger() }

/**
 * All Emoji of the People & Body: hand-single-finger subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listHandSingleFinger(): List<Emoji> =
    ArrayList<Emoji>(countHandSingleFinger).also { list -> sequenceHandSingleFinger().forEach { list.add(it) } }

@Deprecated("Renamed listHandSingleFinger.", replaceWith = ReplaceWith("listHandSingleFinger()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allHandSingleFinger(): List<Emoji> =
    listHandSingleFinger()
