package org.kodein.emoji.people_body.person

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonWhiteHair: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧑‍🦳",
        description = "person: white hair",
        unicodeVersion = UnicodeVersion(12, 1),
        aliases = listOf("person-white-hair", "white-hair"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person: person: white hair.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonWhiteHair: SkinTone1Emoji get() = _PersonWhiteHair

/**
 * Alias to emoji [PersonWhiteHair] (People & Body: person: person: white hair).
*/
public val Emoji.Companion.WhiteHair: SkinTone1Emoji get() = _PersonWhiteHair
