package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.UnqualifiedSkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PersonInSuitLevitating: SkinTone1Emoji = UnqualifiedSkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🕴️",
        description = "person in suit levitating",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("person-in-suit-levitating", "levitating-suit"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    uqString = "🕴",
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: person in suit levitating.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonInSuitLevitating: SkinTone1Emoji get() = _PersonInSuitLevitating

/**
 * Alias to emoji [PersonInSuitLevitating] (People & Body: person-activity: person in suit levitating).
*/
public val Emoji.Companion.LevitatingSuit: SkinTone1Emoji get() = _PersonInSuitLevitating
