package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonWithWhiteCane: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧑‍🦯",
        description = "person with white cane",
        unicodeVersion = UnicodeVersion(12, 1),
        aliases = listOf("person-with-white-cane", "walking-with-cane", "blind"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: person with white cane.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonWithWhiteCane: SkinTone1Emoji get() = _PersonWithWhiteCane

/**
 * Alias to emoji [PersonWithWhiteCane] (People & Body: person-activity: person with white cane).
*/
public val Emoji.Companion.WalkingWithCane: SkinTone1Emoji get() = _PersonWithWhiteCane

/**
 * Alias to emoji [PersonWithWhiteCane] (People & Body: person-activity: person with white cane).
*/
public val Emoji.Companion.Blind: SkinTone1Emoji get() = _PersonWithWhiteCane
