package org.kodein.emoji.people_body.person_role

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPersonRole() {
    add(intArrayOf(0x1f9d1, 0x200d, 0x2695, 0xfe0f), _HealthWorker)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x2695, 0xfe0f), _HealthWorker, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x2695), _HealthWorker)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x2695), _HealthWorker, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x2695), _ManHealthWorker)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x2695), _ManHealthWorker, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x2695, 0xfe0f), _ManHealthWorker)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x2695, 0xfe0f), _ManHealthWorker, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x2695), _WomanHealthWorker)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2695), _WomanHealthWorker, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x2695, 0xfe0f), _WomanHealthWorker)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2695, 0xfe0f), _WomanHealthWorker, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f393), _Student)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f393), _Student, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f393), _ManStudent)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f393), _ManStudent, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f393), _WomanStudent)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f393), _WomanStudent, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f3eb), _Teacher)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f3eb), _Teacher, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f3eb), _ManTeacher)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f3eb), _ManTeacher, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f3eb), _WomanTeacher)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f3eb), _WomanTeacher, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x2696, 0xfe0f), _Judge)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x2696, 0xfe0f), _Judge, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x2696), _Judge)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x2696), _Judge, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x2696), _ManJudge)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x2696), _ManJudge, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x2696, 0xfe0f), _ManJudge)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x2696, 0xfe0f), _ManJudge, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x2696), _WomanJudge)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2696), _WomanJudge, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x2696, 0xfe0f), _WomanJudge)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2696, 0xfe0f), _WomanJudge, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f33e), _Farmer)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f33e), _Farmer, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f33e), _ManFarmer)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f33e), _ManFarmer, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f33e), _WomanFarmer)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f33e), _WomanFarmer, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f373), _Cook)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f373), _Cook, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f373), _ManCook)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f373), _ManCook, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f373), _WomanCook)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f373), _WomanCook, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f527), _Mechanic)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f527), _Mechanic, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f527), _ManMechanic)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f527), _ManMechanic, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f527), _WomanMechanic)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f527), _WomanMechanic, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f3ed), _FactoryWorker)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f3ed), _FactoryWorker, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f3ed), _ManFactoryWorker)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f3ed), _ManFactoryWorker, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f3ed), _WomanFactoryWorker)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f3ed), _WomanFactoryWorker, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f4bc), _OfficeWorker)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f4bc), _OfficeWorker, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f4bc), _ManOfficeWorker)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f4bc), _ManOfficeWorker, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f4bc), _WomanOfficeWorker)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f4bc), _WomanOfficeWorker, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f52c), _Scientist)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f52c), _Scientist, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f52c), _ManScientist)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f52c), _ManScientist, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f52c), _WomanScientist)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f52c), _WomanScientist, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f4bb), _Technologist)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f4bb), _Technologist, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f4bb), _ManTechnologist)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f4bb), _ManTechnologist, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f4bb), _WomanTechnologist)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f4bb), _WomanTechnologist, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f3a4), _Singer)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f3a4), _Singer, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f3a4), _ManSinger)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f3a4), _ManSinger, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f3a4), _WomanSinger)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f3a4), _WomanSinger, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f3a8), _Artist)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f3a8), _Artist, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f3a8), _ManArtist)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f3a8), _ManArtist, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f3a8), _WomanArtist)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f3a8), _WomanArtist, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x2708, 0xfe0f), _Pilot)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x2708, 0xfe0f), _Pilot, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x2708), _Pilot)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x2708), _Pilot, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x2708), _ManPilot)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x2708), _ManPilot, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x2708, 0xfe0f), _ManPilot)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x2708, 0xfe0f), _ManPilot, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x2708), _WomanPilot)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2708), _WomanPilot, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x2708, 0xfe0f), _WomanPilot)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2708, 0xfe0f), _WomanPilot, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f680), _Astronaut)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f680), _Astronaut, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f680), _ManAstronaut)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f680), _ManAstronaut, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f680), _WomanAstronaut)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f680), _WomanAstronaut, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f692), _Firefighter)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f692), _Firefighter, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f692), _ManFirefighter)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f692), _ManFirefighter, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f692), _WomanFirefighter)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f692), _WomanFirefighter, 1)
    add(intArrayOf(0x1f46e), _PoliceOfficer)
    addVariations(intArrayOf(0x1f46e, 0x0), _PoliceOfficer, 1)
    add(intArrayOf(0x1f46e, 0x200d, 0x2642), _ManPoliceOfficer)
    addVariations(intArrayOf(0x1f46e, 0x0, 0x200d, 0x2642), _ManPoliceOfficer, 1)
    add(intArrayOf(0x1f46e, 0x200d, 0x2642, 0xfe0f), _ManPoliceOfficer)
    addVariations(intArrayOf(0x1f46e, 0x0, 0x200d, 0x2642, 0xfe0f), _ManPoliceOfficer, 1)
    add(intArrayOf(0x1f46e, 0x200d, 0x2640), _WomanPoliceOfficer)
    addVariations(intArrayOf(0x1f46e, 0x0, 0x200d, 0x2640), _WomanPoliceOfficer, 1)
    add(intArrayOf(0x1f46e, 0x200d, 0x2640, 0xfe0f), _WomanPoliceOfficer)
    addVariations(intArrayOf(0x1f46e, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanPoliceOfficer, 1)
    add(intArrayOf(0x1f575, 0xfe0f), _Detective)
    add(intArrayOf(0x1f575), _Detective)
    addVariations(intArrayOf(0x1f575, 0x0), _Detective, 1)
    add(intArrayOf(0x1f575, 0xfe0f, 0x200d, 0x2642), _ManDetective)
    add(intArrayOf(0x1f575, 0xfe0f, 0x200d, 0x2642, 0xfe0f), _ManDetective)
    add(intArrayOf(0x1f575, 0x200d, 0x2642, 0xfe0f), _ManDetective)
    addVariations(intArrayOf(0x1f575, 0x0, 0x200d, 0x2642, 0xfe0f), _ManDetective, 1)
    add(intArrayOf(0x1f575, 0x200d, 0x2642), _ManDetective)
    addVariations(intArrayOf(0x1f575, 0x0, 0x200d, 0x2642), _ManDetective, 1)
    add(intArrayOf(0x1f575, 0xfe0f, 0x200d, 0x2640), _WomanDetective)
    add(intArrayOf(0x1f575, 0xfe0f, 0x200d, 0x2640, 0xfe0f), _WomanDetective)
    add(intArrayOf(0x1f575, 0x200d, 0x2640, 0xfe0f), _WomanDetective)
    addVariations(intArrayOf(0x1f575, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanDetective, 1)
    add(intArrayOf(0x1f575, 0x200d, 0x2640), _WomanDetective)
    addVariations(intArrayOf(0x1f575, 0x0, 0x200d, 0x2640), _WomanDetective, 1)
    add(intArrayOf(0x1f482), _Guard)
    addVariations(intArrayOf(0x1f482, 0x0), _Guard, 1)
    add(intArrayOf(0x1f482, 0x200d, 0x2642), _ManGuard)
    addVariations(intArrayOf(0x1f482, 0x0, 0x200d, 0x2642), _ManGuard, 1)
    add(intArrayOf(0x1f482, 0x200d, 0x2642, 0xfe0f), _ManGuard)
    addVariations(intArrayOf(0x1f482, 0x0, 0x200d, 0x2642, 0xfe0f), _ManGuard, 1)
    add(intArrayOf(0x1f482, 0x200d, 0x2640), _WomanGuard)
    addVariations(intArrayOf(0x1f482, 0x0, 0x200d, 0x2640), _WomanGuard, 1)
    add(intArrayOf(0x1f482, 0x200d, 0x2640, 0xfe0f), _WomanGuard)
    addVariations(intArrayOf(0x1f482, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanGuard, 1)
    add(intArrayOf(0x1f977), _Ninja)
    addVariations(intArrayOf(0x1f977, 0x0), _Ninja, 1)
    add(intArrayOf(0x1f477), _ConstructionWorker)
    addVariations(intArrayOf(0x1f477, 0x0), _ConstructionWorker, 1)
    add(intArrayOf(0x1f477, 0x200d, 0x2642), _ManConstructionWorker)
    addVariations(intArrayOf(0x1f477, 0x0, 0x200d, 0x2642), _ManConstructionWorker, 1)
    add(intArrayOf(0x1f477, 0x200d, 0x2642, 0xfe0f), _ManConstructionWorker)
    addVariations(intArrayOf(0x1f477, 0x0, 0x200d, 0x2642, 0xfe0f), _ManConstructionWorker, 1)
    add(intArrayOf(0x1f477, 0x200d, 0x2640), _WomanConstructionWorker)
    addVariations(intArrayOf(0x1f477, 0x0, 0x200d, 0x2640), _WomanConstructionWorker, 1)
    add(intArrayOf(0x1f477, 0x200d, 0x2640, 0xfe0f), _WomanConstructionWorker)
    addVariations(intArrayOf(0x1f477, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanConstructionWorker, 1)
    add(intArrayOf(0x1fac5), _PersonWithCrown)
    addVariations(intArrayOf(0x1fac5, 0x0), _PersonWithCrown, 1)
    add(intArrayOf(0x1f934), _Prince)
    addVariations(intArrayOf(0x1f934, 0x0), _Prince, 1)
    add(intArrayOf(0x1f478), _Princess)
    addVariations(intArrayOf(0x1f478, 0x0), _Princess, 1)
    add(intArrayOf(0x1f473), _PersonWearingTurban)
    addVariations(intArrayOf(0x1f473, 0x0), _PersonWearingTurban, 1)
    add(intArrayOf(0x1f473, 0x200d, 0x2642), _ManWearingTurban)
    addVariations(intArrayOf(0x1f473, 0x0, 0x200d, 0x2642), _ManWearingTurban, 1)
    add(intArrayOf(0x1f473, 0x200d, 0x2642, 0xfe0f), _ManWearingTurban)
    addVariations(intArrayOf(0x1f473, 0x0, 0x200d, 0x2642, 0xfe0f), _ManWearingTurban, 1)
    add(intArrayOf(0x1f473, 0x200d, 0x2640), _WomanWearingTurban)
    addVariations(intArrayOf(0x1f473, 0x0, 0x200d, 0x2640), _WomanWearingTurban, 1)
    add(intArrayOf(0x1f473, 0x200d, 0x2640, 0xfe0f), _WomanWearingTurban)
    addVariations(intArrayOf(0x1f473, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanWearingTurban, 1)
    add(intArrayOf(0x1f472), _PersonWithSkullcap)
    addVariations(intArrayOf(0x1f472, 0x0), _PersonWithSkullcap, 1)
    add(intArrayOf(0x1f9d5), _WomanWithHeadscarf)
    addVariations(intArrayOf(0x1f9d5, 0x0), _WomanWithHeadscarf, 1)
    add(intArrayOf(0x1f935), _PersonInTuxedo)
    addVariations(intArrayOf(0x1f935, 0x0), _PersonInTuxedo, 1)
    add(intArrayOf(0x1f935, 0x200d, 0x2642), _ManInTuxedo)
    addVariations(intArrayOf(0x1f935, 0x0, 0x200d, 0x2642), _ManInTuxedo, 1)
    add(intArrayOf(0x1f935, 0x200d, 0x2642, 0xfe0f), _ManInTuxedo)
    addVariations(intArrayOf(0x1f935, 0x0, 0x200d, 0x2642, 0xfe0f), _ManInTuxedo, 1)
    add(intArrayOf(0x1f935, 0x200d, 0x2640), _WomanInTuxedo)
    addVariations(intArrayOf(0x1f935, 0x0, 0x200d, 0x2640), _WomanInTuxedo, 1)
    add(intArrayOf(0x1f935, 0x200d, 0x2640, 0xfe0f), _WomanInTuxedo)
    addVariations(intArrayOf(0x1f935, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanInTuxedo, 1)
    add(intArrayOf(0x1f470), _PersonWithVeil)
    addVariations(intArrayOf(0x1f470, 0x0), _PersonWithVeil, 1)
    add(intArrayOf(0x1f470, 0x200d, 0x2642), _ManWithVeil)
    addVariations(intArrayOf(0x1f470, 0x0, 0x200d, 0x2642), _ManWithVeil, 1)
    add(intArrayOf(0x1f470, 0x200d, 0x2642, 0xfe0f), _ManWithVeil)
    addVariations(intArrayOf(0x1f470, 0x0, 0x200d, 0x2642, 0xfe0f), _ManWithVeil, 1)
    add(intArrayOf(0x1f470, 0x200d, 0x2640), _WomanWithVeil)
    addVariations(intArrayOf(0x1f470, 0x0, 0x200d, 0x2640), _WomanWithVeil, 1)
    add(intArrayOf(0x1f470, 0x200d, 0x2640, 0xfe0f), _WomanWithVeil)
    addVariations(intArrayOf(0x1f470, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanWithVeil, 1)
    add(intArrayOf(0x1f930), _PregnantWoman)
    addVariations(intArrayOf(0x1f930, 0x0), _PregnantWoman, 1)
    add(intArrayOf(0x1fac3), _PregnantMan)
    addVariations(intArrayOf(0x1fac3, 0x0), _PregnantMan, 1)
    add(intArrayOf(0x1fac4), _PregnantPerson)
    addVariations(intArrayOf(0x1fac4, 0x0), _PregnantPerson, 1)
    add(intArrayOf(0x1f931), _BreastFeeding)
    addVariations(intArrayOf(0x1f931, 0x0), _BreastFeeding, 1)
    add(intArrayOf(0x1f469, 0x200d, 0x1f37c), _WomanFeedingBaby)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f37c), _WomanFeedingBaby, 1)
    add(intArrayOf(0x1f468, 0x200d, 0x1f37c), _ManFeedingBaby)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f37c), _ManFeedingBaby, 1)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f37c), _PersonFeedingBaby)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f37c), _PersonFeedingBaby, 1)
}

internal suspend fun SequenceScope<Emoji>.yieldAllPersonRole() {
    yield(_HealthWorker)
    yield(_ManHealthWorker)
    yield(_WomanHealthWorker)
    yield(_Student)
    yield(_ManStudent)
    yield(_WomanStudent)
    yield(_Teacher)
    yield(_ManTeacher)
    yield(_WomanTeacher)
    yield(_Judge)
    yield(_ManJudge)
    yield(_WomanJudge)
    yield(_Farmer)
    yield(_ManFarmer)
    yield(_WomanFarmer)
    yield(_Cook)
    yield(_ManCook)
    yield(_WomanCook)
    yield(_Mechanic)
    yield(_ManMechanic)
    yield(_WomanMechanic)
    yield(_FactoryWorker)
    yield(_ManFactoryWorker)
    yield(_WomanFactoryWorker)
    yield(_OfficeWorker)
    yield(_ManOfficeWorker)
    yield(_WomanOfficeWorker)
    yield(_Scientist)
    yield(_ManScientist)
    yield(_WomanScientist)
    yield(_Technologist)
    yield(_ManTechnologist)
    yield(_WomanTechnologist)
    yield(_Singer)
    yield(_ManSinger)
    yield(_WomanSinger)
    yield(_Artist)
    yield(_ManArtist)
    yield(_WomanArtist)
    yield(_Pilot)
    yield(_ManPilot)
    yield(_WomanPilot)
    yield(_Astronaut)
    yield(_ManAstronaut)
    yield(_WomanAstronaut)
    yield(_Firefighter)
    yield(_ManFirefighter)
    yield(_WomanFirefighter)
    yield(_PoliceOfficer)
    yield(_ManPoliceOfficer)
    yield(_WomanPoliceOfficer)
    yield(_Detective)
    yield(_ManDetective)
    yield(_WomanDetective)
    yield(_Guard)
    yield(_ManGuard)
    yield(_WomanGuard)
    yield(_Ninja)
    yield(_ConstructionWorker)
    yield(_ManConstructionWorker)
    yield(_WomanConstructionWorker)
    yield(_PersonWithCrown)
    yield(_Prince)
    yield(_Princess)
    yield(_PersonWearingTurban)
    yield(_ManWearingTurban)
    yield(_WomanWearingTurban)
    yield(_PersonWithSkullcap)
    yield(_WomanWithHeadscarf)
    yield(_PersonInTuxedo)
    yield(_ManInTuxedo)
    yield(_WomanInTuxedo)
    yield(_PersonWithVeil)
    yield(_ManWithVeil)
    yield(_WomanWithVeil)
    yield(_PregnantWoman)
    yield(_PregnantMan)
    yield(_PregnantPerson)
    yield(_BreastFeeding)
    yield(_WomanFeedingBaby)
    yield(_ManFeedingBaby)
    yield(_PersonFeedingBaby)
}

internal val countPersonRole = 82

/**
 * All Emoji of the People & Body: person-role subgroup.
*/
public fun Emoji.Companion.sequencePersonRole(): Sequence<Emoji> =
    sequence { yieldAllPersonRole() }

/**
 * All Emoji of the People & Body: person-role subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listPersonRole(): List<Emoji> =
    ArrayList<Emoji>(countPersonRole).also { list -> sequencePersonRole().forEach { list.add(it) } }

@Deprecated("Renamed listPersonRole.", replaceWith = ReplaceWith("listPersonRole()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allPersonRole(): List<Emoji> =
    listPersonRole()
