package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonSwimming: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🏊",
        description = "person swimming",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-swimming", "swimming"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-sport: person swimming.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonSwimming: SkinTone1Emoji get() = _PersonSwimming

/**
 * Alias to emoji [PersonSwimming] (People & Body: person-sport: person swimming).
*/
public val Emoji.Companion.Swimming: SkinTone1Emoji get() = _PersonSwimming
