package org.kodein.emoji.smileys_emotion.emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SweatDroplets: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💦",
        description = "sweat droplets",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("sweat-droplets", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: emotion: sweat droplets.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SweatDroplets: Emoji get() = _SweatDroplets
